/*******************************************************
Filename		:  create_temp_tables.sql
Release 		:  c2.0
SIR			:  1497
Description		:  create temp tables
Author			:  Ganesh Thadkamalla, Joseph Wilson
Date			:  2-28-2003
Comments		:  Run this script after FA_REGULAR_RESULT_temp1.sql and before FA_REGULAR_RESULT_temp2.sql -Ganesh.
			   6/17/2003 --Edited for STORET v2.0 compliance. Edited fdact_temp2 creation. --Ganesh.
			   7-01-2003 --changed names from CHEM to REGULAR; added new 2.0 columns and removed outdated -JW
				     -- added fieldset_temp -JW
			   7-03-2003 -- updated dates to single date/time values -JW
			   7-21-2003 -- added sample pres temp table -JW
			   7-29-2003 -- updated sample pres temp talbe logic -JW
			   7-31-2003 -- update date logic -JW	
			   8-04-2003 -- added long_temp table; added fieldset index and analyze statements -JW		
			   8-11-2003 -- updated sample_pres_temp; moved fieldset_temp after fdact2 duplicate clean-up -JW   
                     	   8-13-2003 -- incorporated Activity location logic for child samples from the all_regular_results view. -C Tsang
			   8-26-2003 -- updated time logic -JW
                     	   8/27/2003 - SIR 1495 TIR#7 - Nullified well_number and pipe_number when point type not 'WELL HEAD' or
                                 'END OF PIPE'. -C Tsang
			   1/07/2004 - added tsmalp_is_number to FDACT_TEMP2 -JW
			   01/16/04 - SIR 1586 Moved connect string to master install 
script -JW
	06/09/2004 added station_is_number to fdact_temp2 table -GT
	01/19/2004 - added translate commands to replace return with paragraph marker (PRESRV_STRGE_PRCDR), long_temp.long_text field. - GT
**********************************************************/

spool create_temp_tables.log

-- field activity related temp tables.

drop index ire_act_is_num_org_id;
create index ire_act_is_num_org_id on FA_REGULAR_RESULT (activity_is_number,organization_id)
tablespace storetindx
storage (initial 10M next 10M)
nologging;

drop table fdact_temp;
create table fdact_temp 
tablespace storetdata
storage ( initial 5M next 5M maxextents 500)
nologging
pctfree 1 
as select distinct activity_is_number,organization_id, 0 flag from FA_REGULAR_RESULT;
commit;

create index ift_act_is_num_org_id on fdact_temp (activity_is_number,organization_id)
tablespace storetindx
storage (initial 3M next 2M)
nologging;

create bitmap index ift_flag on Fdact_temp(flag)
tablespace storetindx
storage (initial 2M next 2M maxextents 500)
nologging;

drop sequence seq_fdact_temp2;

create sequence seq_fdact_temp2
start with 1 increment by 1 nomaxvalue nocycle cache 100;

-- creating AAL temp tables.
-- activity point table
drop table tsraal_AP ;
create table tsraal_AP 
tablespace storetdata
storage (initial 10M next 5M)
unrecoverable as
select a.TSMALP_IS_NUMBER,
 a.TSMALP_ORG_ID,
 a.TSRFDACT_IS_NUMBER,
 a.TSRFDACT_ORG_ID,
 a.TSRAAL_TYPE_NAME,
 a.BOTTOM_DEPTH_MSR,
 a.BOTTOM_DEPTH_UN_CD,
 a.ADDTNL_LOC_INFO,
 a.D_USERID_CODE,
 a.D_LAST_UPDATE_TS
from storet1.tsraal a, storet1.tsmalp p
where a.tsmalp_is_number = p.tsmalp_is_number
  and a.tsmalp_org_id = p.tsmalp_org_id
  and p.type_code = 'ACTIVITY POINT'
  and a.TSRAAL_TYPE_NAME in ('General','Trawl Stop');

INSERT INTO tsraal_AP (
  TSMALP_IS_NUMBER    ,   
  TSMALP_ORG_ID       ,   
  TSRFDACT_IS_NUMBER  ,   
  TSRFDACT_ORG_ID     ,   
  TSRAAL_TYPE_NAME    ,   
  BOTTOM_DEPTH_MSR    ,   
  BOTTOM_DEPTH_UN_CD  ,   
  ADDTNL_LOC_INFO     ,   
  D_USERID_CODE       ,   
  D_LAST_UPDATE_TS    
)
SELECT   
 a.TSMALP_IS_NUMBER,
 a.TSMALP_ORG_ID,
 f1.TSRFDACT_IS_NUMBER,
 f1.TSRFDACT_ORG_ID,
 a.TSRAAL_TYPE_NAME,
 a.BOTTOM_DEPTH_MSR,
 a.BOTTOM_DEPTH_UN_CD,
 a.ADDTNL_LOC_INFO,
 a.D_USERID_CODE,
 a.D_LAST_UPDATE_TS
from storet1.tsraal a, storet1.tsrfdact f1, storet1.tsmalp p
where a.tsrfdact_is_number = f1.tsrfdact1is_number
  and a.tsrfdact_org_id = f1.tsrfdact1org_id
  and f1.CATEGORY_TYPE_NAME = 'Created from Sample'
  and a.tsmalp_is_NUmber = p.tsmalp_is_number
  and a.tsmalp_org_id = p.tsmalp_org_id
  and p.type_code = 'ACTIVITY POINT'
  and a.TSRAAL_TYPE_NAME in ('General','Trawl Stop');
commit;

create index ind_aal_ap_01 on tsraal_ap(TSMALP_IS_NUMBER,TSMALP_ORG_ID,TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID,TSRAAL_TYPE_NAME)
tablespace storetindx
storage (initial 5M next 3M)
nologging;

create index ind_aal_ap_02 on tsraal_ap(TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID)
tablespace storetindx
storage (initial 5M next 3M)
nologging;

-- non-activity point table
drop table tsraal_nap ;
create table tsraal_nap 
tablespace storetdata
storage (initial 10M next 5M)
unrecoverable as
select a.TSMALP_IS_NUMBER,
 a.TSMALP_ORG_ID,
 a.TSRFDACT_IS_NUMBER,
 a.TSRFDACT_ORG_ID,
 a.TSRAAL_TYPE_NAME,
 a.BOTTOM_DEPTH_MSR,
 a.BOTTOM_DEPTH_UN_CD,
 a.ADDTNL_LOC_INFO,
 a.D_USERID_CODE,
 a.D_LAST_UPDATE_TS
from storet1.tsraal a, storet1.tsmalp p
where a.tsmalp_is_number = p.tsmalp_is_number
  and a.tsmalp_org_id = p.tsmalp_org_id
  and p.type_code != 'ACTIVITY POINT';

INSERT INTO tsraal_NAP (
  TSMALP_IS_NUMBER    ,   
  TSMALP_ORG_ID       ,   
  TSRFDACT_IS_NUMBER  ,   
  TSRFDACT_ORG_ID     ,   
  TSRAAL_TYPE_NAME    ,   
  BOTTOM_DEPTH_MSR    ,   
  BOTTOM_DEPTH_UN_CD  ,   
  ADDTNL_LOC_INFO     ,   
  D_USERID_CODE       ,   
  D_LAST_UPDATE_TS    
)
SELECT   
 a.TSMALP_IS_NUMBER,
 a.TSMALP_ORG_ID,
 f1.TSRFDACT_IS_NUMBER,
 f1.TSRFDACT_ORG_ID,
 a.TSRAAL_TYPE_NAME,
 a.BOTTOM_DEPTH_MSR,
 a.BOTTOM_DEPTH_UN_CD,
 a.ADDTNL_LOC_INFO,
 a.D_USERID_CODE,
 a.D_LAST_UPDATE_TS
from storet1.tsraal a, storet1.tsrfdact f1, storet1.tsmalp p
where a.tsrfdact_is_number = f1.tsrfdact1is_number
  and a.tsrfdact_org_id = f1.tsrfdact1org_id
  and f1.CATEGORY_TYPE_NAME = 'Created from Sample'
  and a.tsmalp_is_NUmber = p.tsmalp_is_number
  and a.tsmalp_org_id = p.tsmalp_org_id
  and p.type_code != 'ACTIVITY POINT';
commit;

create index ind_aal_nap_01 on 
tsraal_nap(TSMALP_IS_NUMBER,TSMALP_ORG_ID,TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID,TSRAAL_TYPE_NAME)
tablespace storetindx
storage (initial 5M next 3M)
nologging;

create index ind_aal_nap_02 on tsraal_nap(TSRFDACT_IS_NUMBER,TSRFDACT_ORG_ID)
tablespace storetindx
storage (initial 5M next 3M)
nologging;

-- creating fdact_temp2 table
drop table fdact_temp2;
create table fdact_temp2 
tablespace storetdata
storage (initial 200M next 100M)
pctfree 1 nologging as
select seq_fdact_temp2.nextval activity_isn, ft.activity_is_number , ft.organization_id,
 nvl(AP_ALP.TYPE_CODE,nap_ALP.TYPE_CODE)				LOCATION_POINT_TYPE,
--added 1/7
 nvl(AP_ALP.tsmalp_is_number,nap_ALP.tsmalp_is_number)			tsmalp_is_number,
 nvl(AP_ALP.SEQUENCE_NUMBER,nap_ALP.SEQUENCE_NUMBER)		POINT_SEQUENCE_NUMBER,
  W.ID_NUMBER well_number,
  p.ID_NUMBER pipe_number,
  NVL(AP_ALP.LAT_DEC_DEG_MSR,nap_ALP.LAT_DEC_DEG_MSR)  activity_LATITUDE,
  NVL(AP_ALP.LONG_DEC_DEG_MSR,nap_ALP.LONG_DEC_DEG_MSR) activity_LONGITUDE,
  NVL(AP_ALP.POINT_NAME,nap_ALP.POINT_NAME) POINT_NAME,
  NVL(AP_ALP.GEOPSTNG_SCALE_TXT,nap_ALP.GEOPSTNG_SCALE_TXT) MAP_SCALE,
  nvl(ap_mad_hd.pk_isn,nap_mad_hd.pk_isn) FK_act_mad_hdatum,
  nvl(ap_mad_hm.pk_isn,nap_mad_hm.pk_isn) fk_act_mad_hmethod,
  nap_alp.tsmstatn0is_number station_is_number
from tsraal_ap ap_aal, storet1.tsmalp ap_alp,tsraal_nap nap_aal, storet1.tsmalp nap_alp, storet1.tsmwell w,
   storet1.tsmpipe p,storetw.lu_mad_hmethod ap_mad_hm, storetw.lu_mad_hdatum ap_mad_hd,
   storetw.lu_mad_hmethod nap_mad_hm, storetw.lu_mad_hdatum nap_mad_hd, fdact_temp ft
where  FT.activity_IS_NUMBER = AP_AAL.TSRFDACT_IS_NUMBER (+)
AND FT.organization_id = AP_AAL.TSRFDACT_ORG_ID (+)
AND AP_AAL.TSMALP_IS_NUMBER  = AP_ALP.TSMALP_IS_NUMBER (+)
AND AP_AAL.TSMALP_ORG_ID  = AP_ALP.TSMALP_ORG_ID (+)
AND FT.activity_IS_NUMBER = nap_AAL.TSRFDACT_IS_NUMBER (+)
AND FT.organization_id= nap_AAL.TSRFDACT_ORG_ID (+)
AND nap_AAL.TSMALP_IS_NUMBER  = NAP_ALP.TSMALP_IS_NUMBER (+)
AND nap_AAL.TSMALP_ORG_ID  = NAP_ALP.TSMALP_ORG_ID (+)
  and nap_alp.tsmwell_is_number = w.tsmwell_is_number (+)
  and nap_alp.tsmwell_org_id = w.tsmwell_org_id (+)
  and nap_alp.tsmpipe_is_number = p.tsmpipe_is_number (+)
  and nap_alp.tsmpipe_org_id = p.tsmpipe_org_id (+)
  and ap_alp.geopstng_datum_cd = ap_mad_hd.id_code (+)
  and ap_alp.geopstng_method_cd = ap_mad_hM.id_code (+)
  and nap_alp.geopstng_datum_cd = nap_mad_hd.id_code (+)
  and nap_alp.geopstng_method_cd = nap_mad_hM.id_code (+);

update fdact_temp2
set WELL_NUMBER = null
where rtrim(LOCATION_POINT_TYPE) <> 'WELL HEAD';
commit;

update fdact_temp2
set PIPE_NUMBER = null
where rtrim(LOCATION_POINT_TYPE) <> 'END OF PIPE';
commit;

create index ift2_act_isnorgid on fdact_temp2(activity_is_number,organization_id) 
tablespace storetindx
storage (initial 10M next 5M)
nologging;

-- Station information related temp table.
drop table statninfo_temp;
create table statnINFO_temp
tablespace storetdata
storage (initial 20M next 10M)
pctfree 1 nologging as
SELECT
STATN.IDENTIFICATION_CD STATION_ID,
STATN.NAME station_name,
TRIP.ID_CODE trip_id,
TRIP.NAME trip_name,
STVST.ID_NUMBER STATION_VISIT_ID,
STATN.TSMSTATN_IS_NUMBER,
STVST.TSRSTVST_IS_NUMBER,
STVST.TSRSTVST_ORG_ID,
TO_DATE(DECODE (to_char(STVST.ARRIVAL_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(STVST.ARRIVAL_date,'DD-MON-YYYY')||'-'||to_char(STVST.ARRIVAL_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') VISIT_START_DATE_TIME,
--TO_DATE(to_char(STVST.ARRIVAL_DATE,'DD-MON-YYYY')||to_char(STVST.ARRIVAL_TIME,'HH24:MI:SS'),'DD-MON-YYYYHH24:MI:SS') VISIT_START_DATE_TIME, 
--STVST.ARRIVAL_DATE		VISIT_START_DATE,
--STVST.ARRIVAL_TIME		VISIT_START_TIME,
STVST.ARRIVAL_TIME_ZONE		VISIT_START_TIME_ZONE,
TO_DATE(DECODE (to_char(STVST.DEPARTURE_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(STVST.DEPARTURE_date,'DD-MON-YYYY')||'-'||to_char(STVST.DEPARTURE_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') VISIT_STOP_DATE_TIME,
--TO_DATE(to_char(STVST.DEPARTURE_DATE,'DD-MON-YYYY')||to_char(STVST.DEPARTURE_TIME,'HH24:MI:SS'),'DD-MON-YYYYHH24:MI:SS') VISIT_STOP_DATE_TIME, 
--STVST.DEPARTURE_DATE		VISIT_STOP_DATE,
--STVST.DEPARTURE_TIME		VISIT_STOP_TIME,
STVST.DEPRTURE_TIME_ZONE	VISIT_STOP_TIME_ZONE
  FROM storet1.TSMSTATN STATN,
   storet1.TSRTRIP TRIP,
   storet1.TSRSTVST STVST
  WHERE STVST.TSRTRIP_IS_NUMBER = TRIP.TSRTRIP_IS_NUMBER
   AND STVST.TSRTRIP_ORG_ID = TRIP.TSRTRIP_ORG_ID
   AND STVST.TSMSTATN_IS_NUMBER = STATN.TSMSTATN_IS_NUMBER
   AND STVST.TSMSTATN_ORG_ID = STATN.TSMSTATN_ORG_ID;

create index isi_temp_stvstkey on statninfo_temp(tsrstvst_is_number,tsrstvst_org_id)
tablespace storetindx
storage (initial 10M next 10M)
nologging;

commit;

--check fdact_temp2 data for data problems.
-- This query should not yield any rows.  If any rows are returned then fix the bad data before proceding.

select 'Note:  Following select should not yield any rows. If it returns rows then there is problem with fdact_temp2 data.' from dual;

select activity_is_number,organization_id,count(*)
from fdact_temp2
group by activity_is_number,organization_id
having count(*)  > 1;

select 'Following delete statement fixes the fdact_temp2 data by deleting duplicate rows by keeping max(rowid)' from dual;

delete from fdact_temp2 a
where a.rowid < (select max(b.rowid) from fdact_temp2 b
         where b.activity_is_number = a.activity_is_number
           and b.organization_id = a.organization_id);

commit;

--field set temp table
-- fieldset_temp_new table is created in f_fieldset.sql function script.

drop table fieldset_temp;
create table fieldset_temp
tablespace storetdata
storage (initial 10M next 5M)
pctfree 1 nologging as
SELECT activity_is_number, organization_id, f_fieldset(ACTIVITY_IS_NUMBER, ORGANIZATION_ID) field_set
	FROM fdact_temp2 ft2;

DELETE FROM fieldset_temp WHERE field_set IS NULL;
COMMIT;
--
create index ifieldset_temp_01 on fieldset_temp(ACTIVITY_IS_NUMBER, ORGANIZATION_ID)
tablespace storetindx
storage(initial 4M next 4M)
nologging;

analyze table fieldset_temp compute statistics;
analyze index ifieldset_temp_01 compute statistics;

-- lab remark related temp tables.

DROP TABLE rlra_temp;
create table rlra_temp
tablespace storetdata
storage (initial 10M next 10M)
pctfree 1 nologging as
select distinct tsrrsult_is_number,tsrrsult_org_id
from storet1.tsrrlra;

DROP TABLE  lbrmk_temp;
create table lbrmk_temp
tablespace storetdata
storage (initial 4M next 2M)
pctfree 1 nologging as
select tsrrsult_is_number,tsrrsult_org_id,flbrmk(tsrrsult_is_number,tsrrsult_org_id) lbrmk
from rlra_temp;

create index ilbrmk_temp_01 on lbrmk_temp(tsrrsult_is_number,tsrrsult_org_id)
tablespace storetindx
storage(initial 4M next 4M)
nologging;

create index ifa_result_lbrmk_01 on FA_REGULAR_RESULT(result_is_number,organization_id)
tablespace storetindx
storage(initial 10M next 10M)
nologging;

analyze table lbrmk_temp compute statistics;
analyze index ilbrmk_temp_01 compute statistics;
analyze index ifa_result_lbrmk_01 compute statistics;

--SAMPLE PRES TEMP
drop table sample_pres_temp;

create table sample_pres_temp
tablespace storetdata
storage (initial 10M next 10M) nologging pctfree 1 as
	select CONTAINER_TYPE_NM,CONTAINER_COLOR,CONTAINER_SIZE_MSR,CONTAINER_SIZE_UN,
		TEMP_PRESERVN_TYPE,TSMPRMVL_IS_NUMBER,TSMPRMVL0IS_NUMBER,TSMPRMVL1IS_NUMBER,
		SUBSTR(translate(PRESRV_STRGE_PRCDR,chr(10),chr(182)),1,256) PRESRV_STRGE_PRCDR, 
                smple.tsrfdact_is_number,smple.tsrfdact_org_id
	from storet1.tsrsmple smple, fdact_temp tp
	where tp.activity_is_number = smple.tsrfdact_is_number
	and tp.organization_id = smple.tsrfdact_org_id;

update sample_pres_temp tp
set (CONTAINER_TYPE_NM) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = tp.tsmprmvl_is_number 
           and b.field_name = 'CONTAINER_TYPE_NM'
           and b.table_name = 'TSRSMPLE')
WHERE TP.TSMPRMVL_IS_NUMBER IS NOT NULL;

update sample_pres_temp tp
set (TEMP_PRESERVN_TYPE) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = tp.tsmprmvl1is_number 
           and b.field_name = 'TEMP_PRESERVN_TYPE'
           and b.table_name = 'TSRSMPLE')
WHERE TP.TSMPRMVL1IS_NUMBER IS NOT NULL;

update sample_pres_temp tp
set (CONTAINER_COLOR) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = tp.tsmprmvl0is_number 
           and b.field_name = 'CONTAINER_COLOR'
           and b.table_name = 'TSRSMPLE')
WHERE TP.TSMPRMVL0IS_NUMBER IS NOT NULL;
commit;

update sample_pres_temp tp
	set CONTAINER_SIZE_MSR = to_number(NULL)
	WHERE CONTAINER_SIZE_MSR = 0;
commit;

alter table sample_pres_temp add container_desc varchar2(60);

update sample_pres_temp
set container_desc = (container_color||' '||container_type_nm||' '||CONTAINER_SIZE_MSR||' '||CONTAINER_SIZE_UN);

commit;

create index isample_pres_temp on sample_pres_temp(tsrfdact_is_number,tsrfdact_org_id)
tablespace storetindx
storage(initial 10M next 10M)
nologging;

DROP TABLE LONG_TEMP;

CREATE TABLE LONG_TEMP (
pk_isn			NUMBER(12),
long_text		VARCHAR2(4000),
long_type		VARCHAR2(8),
organization_id		CHAR(8),
result_is_number	NUMBER(12))
tablespace storetdata
storage (initial 5 M next 5M);

-- edited for SIR 1677
INSERT INTO LONG_TEMP (long_text,long_type,organization_id,result_is_number)
	SELECT translate(description_text,chr(10),chr(182)), 
		description_name,
		tsrrsult_org_id,
		tsrrsult_is_number
	FROM storet1.tsmgntxt
	WHERE description_name in ('DESCRIPT', 'RSLTCMNT');

COMMIT;

-- this delete is to handle any duplicate data.
delete from long_temp
where rowid in
(
select b.row_id
from
(select min(rowid) row_id, result_is_number, organization_id,long_type from long_temp
	group by result_is_number, organization_id,long_type) a,
(select rowid row_id,result_is_number, organization_id, long_type from long_temp) b
where a.result_is_number = b.result_is_number
      and  a.organization_id = b.organization_id
      and  a.long_type = b.long_type
      and  a.row_id<>b.row_id
);
commit;

create index isi_temp_longkey on long_temp(result_is_number,organization_id)
tablespace storetindx
storage (initial 10M next 10M)
nologging;

spool off
